;;;
;;; applesoft.lisp
;;;
;;; Code to decode Apple II Applesoft BASIC programs
;;;
;;; Joe Oswald
;;; 24 Jan 2000
;;;

(defun applesoft-text (code)
  (case code
    (58 ": ")
    (128 "END")
    (129 "FOR ")
    (130 "NEXT ")
    (131 "DATA ")
    (132 "INPUT ")
    (133 "DEL ")
    (134 "DIM ")
    (135 "READ ")
    (136 "GR ")
    (137 "TEXT")
    (138 "PR# ")
    (139 "IN# ")
    (140 "CALL ")
    (141 "PLOT ")
    (142 "HLIN ")
    (143 "VLIN ")
    (144 "HGR2 ")
    (145 "HGR ")
    (146 "HCOLOR= ")
    (147 "HPLOT ")
    (148 "DRAW ")
    (149 "XDRAW ")
    (150 "HTAB ")
    (151 "HOME ")
    (152 "ROT= ")
    (153 "SCALE= ")
    (154 "SHLOAD ")
    (155 "TRACE ")
    (156 "NOTRACE ")
    (157 "NORMAL ")
    (158 "INVERSE ")
    (159 "FLASH")
    (160 "COLOR= ")
    (161 "POP ")
    (162 "VTAB ")
    (163 "HIMEM: ")
    (164 "LOMEM: ")
    (165 "ONERR ")
    (166 "RESUME ")
    (167 "RECALL ")
    (168 "STORE ")
    (169 "SPEED= ")
    (170 "LET ")
    (171 "GOTO ")
    (172 "RUN ")
    (173 "IF ")
    (174 "RESTORE ")
    (175 "& ")
    (176 "GOSUB ")
    (177 "RETURN ")
    (178 "REM ")
    (179 "STOP ")
    (180 "ON ")
    (181 "WAIT ")
    (182 "LOAD ")
    (183 "SAVE ")
    (184 "DEF ")
    (185 "POKE ")
    (186 "PRINT ")
    (187 "CONT ")
    (188 "LIST ")
    (189 "CLEAR ")
    (190 "GET ")
    (191 "NEW ")
    (192 "TAB( ")
    (193 " TO ")
    (194 "FN ")
    (195 "SPC( ")
    (196 "THEN ")
    (197 "AT ")
    (198 "NOT ")
    (199 "STEP ")
    (200 " + ")
    (201 " - ")
    (202 " * ")
    (203 " / ")
    (204 " ^ ")
    (205 " AND ")
    (206 " OR ")
    (207 " > ")
    (208 " = ")
    (209 " < ")
    (210 "SGN ")
    (211 "INT ")
    (212 "ABS ")
    (213 "USR ")
    (214 "FRE ")
    (215 "SCRN( ")
    (216 "PDL ")
    (217 "POS ")
    (218 "SQR ")
    (219 "RND ")
    (220 "LOG ")
    (221 "EXP ")
    (222 "COS ")
    (223 "SIN ")
    (224 "TAN ")
    (225 "ATN ")
    (226 "PEEK ")
    (227 "LEN ")
    (228 "STR$ ")
    (229 "VAL ")
    (230 "ASC ")
    (231 " CHR$")
    (232 "LEFT$")
    (233 "RIGHT$ ")
    (234 "MID$ ")
    (235 " ")
    (236 "SYNTAX ")
    (237 "RETURN WITHOUT GOSUB")
    (238 "OUT OF DATA")
    (239 "ILLEGAL QUANTITY ")
    (240 "OVERFLOW ")
    (241 "OUT OF MEMORY ")
    (242 "UNDEF'D STATEMENT ")
    (243 "BAD SUBSCRIPT ")
    (244 "REDIM'D ARRAY ")
    (245 "DIVISION BY ZERO ")
    (246 "ILLEGAL DIRECT ")
    (247 "TYPE MISMATCH ")
    (248 "STRING TOO LONG ")
    (249 "FORMULA TOO COMPLEX ")
    (250 "CAN'T CONTINUE ")
    (251 "UNDEF'D FUNCTION ")
    (252 " ERROR")
    (253 " ( ")
    (254 " ( ")
    (255 " ( ")
    (t (string (code-char code)))))

  
(defun slurp-applesoft (data-array offset)
  (do ((off offset (1+ off))
       (s (string "")))
      ((zerop (aref data-array off)) (values s (1+ (- off offset))))
    (setf s (concatenate 'string s (applesoft-text (aref data-array off))))))

(defun decode-applesoft-line (data-array offset &key (initial-address #x801))
  (labels ((get-16-bit (offset)
             (+ (aref data-array offset) 
                (* 256 (aref data-array (1+ offset))))))
    
    (let ((next-line-address (get-16-bit offset)))
      (if (zerop next-line-address)
        (values nil nil)
        (let ((line-number (get-16-bit (+ 2 offset))))
          (multiple-value-bind (string-form line-bytes)
                               (slurp-applesoft data-array (+ offset 4))
            (values line-number next-line-address string-form (+ 4 line-bytes))))))))